#pragma once

#define IDC_EDIT_CHANNEL_CH01										10001
#define IDC_EDIT_CHANNEL_CH01_SUB								10017
#define IDC_COMBO_RESOLUTION_CH01								10033
#define IDC_COMBO_RESOLUTION_CH01_SUB					10049
#define IDC_COMBO_DEINTERLACE_CH01							10065
#define IDC_COMBO_DEINTERLACE_CH01_SUB					10081
#define IDC_COMBO_FRAMERATE_CH01								10097
#define IDC_COMBO_FRAMERATE_CH01_SUB					10113
#define IDC_COMBO_RECORDMODE_CH01							10129
#define IDC_COMBO_RECORDMODE_CH01_SUB					10145
#define IDC_COMBO_BITRATE_CH01									10161
#define IDC_COMBO_BITRATE_CH01_SUB							10177
#define IDC_COMBO_QUALITY_CH01									10193
#define IDC_COMBO_QUALITY_CH01_SUB							10209
#define IDC_COMBO_GOP_CH01												10225
#define IDC_COMBO_GOP_CH01_SUB									10241
#define IDC_COMBO_BFRAME_CH01										10257
#define IDC_COMBO_BFRAME_CH01_SUB							10273
#define IDC_COMBO_VIDEO_ENCODER_CH01						10289
#define IDC_COMBO_VIDEO_ENCODER_CH01_SUB			10305
#define IDC_COMBO_AUDIO_ENCODER_CH01					10321
#define IDC_COMBO_AUDIO_ENCODER_CH01_SUB			10337
#define IDC_COMBO_FILE_TYPE_CH01									10353
#define IDC_COMBO_FILE_TYPE_CH01_SUB						10369
#define IDC_BTN_START_RECORD_CH01								10385
#define IDC_BTN_START_RECORD_CH01_SUB					10401
#define IDC_BTN_STOP_RECORD_CH01								10417
#define IDC_BTN_STOP_RECORD_CH01_SUB						10433
#define IDC_BTN_SCHEDULE_RECORD_CH01						10449

#include "SchduleRecordDlg.h"

// CSetupDialog dialog

class CSetupDialog : public CDialogEx
{
	DECLARE_DYNAMIC(CSetupDialog)

public:
	CSetupDialog(CWnd* pParent = NULL);   // standard constructor
	virtual ~CSetupDialog();

// Dialog Data
	//{{AFX_DATA(CSetupDialog)
	enum { IDD = IDD_SETUP_DIALOG };
	CComboBox		m_comboStandard;
	CEdit					m_editStopRecord;
	CEdit					m_editStartRecord;
	CEdit					m_editScheduleRecord;
	CEdit					m_editFileType;
	CEdit					m_editAudioEncoder;
	CEdit					m_editVideoEncoder;
	CEdit					m_editBFrame;
	CEdit					m_editGOP;
	CEdit					m_editQuality;
	CEdit					m_editBitRate;
	CEdit					m_editRecordMode;
	CEdit					m_editFrameRate;
	CEdit					m_editDeinterlace;
	CEdit					m_editResolution;
	CEdit					m_editChannel;
	CEdit					m_editStandard;
	//}}AFX_DATA

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand( UINT nID, LPARAM lParam );
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnScheduleRecord();
	afx_msg void OnSelChangeComboStandard();
	afx_msg void OnDestroy();
	afx_msg void OnMainRecordModeSelectChange(UINT nID);
	afx_msg void OnSubRecordModeSelectChange(UINT nID);
	afx_msg void OnMainStartRecord(UINT nID);
	afx_msg void OnMainStopRecord(UINT nID);
	afx_msg void OnMainScheduleRecord(UINT nID);
	DECLARE_MESSAGE_MAP()

public:

	CString							m_strCaption;

	CString							m_strDeviceName;

	CString							m_strScheduleDir;

	CHAR							m_pszDevName[ 20 ];

	ULONG						m_nCHNum;

	BOOL							m_bHasSubStream;

	BOOL							m_bHasBFrame;

	HGLOBAL					m_hGlobalRes;

	CString							m_strTxtData;

	DWORD						m_dwTxtDataSize;

	CEdit							m_editMainChannel[ MAX_CHANNEL ];

	CEdit							m_editSubChannel[ MAX_CHANNEL ];

	CComboBox				m_comboxMainResolution[ MAX_CHANNEL ];

	CComboBox				m_comboxSubResolution[ MAX_CHANNEL ];

	CComboBox				m_comboxMainDeinterlace[ MAX_CHANNEL ];

	CComboBox				m_comboxSubDeinterlace[ MAX_CHANNEL ];

	CComboBox				m_comboxMainFrameRate[ MAX_CHANNEL ];

	CComboBox				m_comboxSubFrameRate[ MAX_CHANNEL ];

	CComboBox				m_comboxMainRecordMode[ MAX_CHANNEL ];

	CComboBox				m_comboxSubRecordMode[ MAX_CHANNEL ];

	CComboBox				m_comboxMainBitrate[ MAX_CHANNEL ];

	CComboBox				m_comboxSubBitrate[ MAX_CHANNEL ];

	CComboBox				m_comboxMainQuality[ MAX_CHANNEL ];

	CComboBox				m_comboxSubQuality[ MAX_CHANNEL ];

	CComboBox				m_comboxMainGop[ MAX_CHANNEL ];

	CComboBox				m_comboxSubGop[ MAX_CHANNEL ];

	CComboBox				m_comboxMainBFrame[ MAX_CHANNEL ];

	CComboBox				m_comboxSubBFrame[ MAX_CHANNEL ];

	CComboBox				m_comboxMainVideoEncoder[ MAX_CHANNEL ];

	CComboBox				m_comboxSubVideoEncoder[ MAX_CHANNEL ];

	CComboBox				m_comboxMainAudioEncoder[ MAX_CHANNEL ];

	CComboBox				m_comboxSubAudioEncoder[ MAX_CHANNEL ];

	CComboBox				m_comboxMainFileType[ MAX_CHANNEL ];

	CComboBox				m_comboxSubFileType[ MAX_CHANNEL ];

	CButton						m_btnMainStartRecord[ MAX_CHANNEL ];

	CButton						m_btnMainStoptRecord[ MAX_CHANNEL ];

	CButton						m_btnMainScheduleRecord[ MAX_CHANNEL ];

	//CButton						m_btnSubStartRecord[ MAX_CHANNEL ];	

	//CButton						m_btnSubStopRecord[ MAX_CHANNEL ];

	CFileRenderer *			m_pMainFileRenderer[ MAX_CHANNEL ];

	//CMenu						m_PopupMenu;

	CSchduleRecordDlg	m_oSchduleRecordDlg;	

	BOOL							m_bManualRecord[ MAX_CHANNEL ];

	//BOOL							m_bRecordManually[ MAX_CHANNEL ];

	//BOOL							m_bStopManually[ MAX_CHANNEL ];

public:

	// NTSC
	//
	vector<string>		m_strVecNtscRes;

	vector<string>		m_strVecNtscResSub;

	vector<string>		m_strVecNtscFrameRate;

	vector<string>		m_strVecNtscRecordMode;

	vector<string>		m_strVecNtscBitrate;

	vector<string>		m_strVecNtscQuality;

	vector<string>		m_strVecNtscQpstep;

	vector<string>		m_strVecNtscPeakBitrate;

	vector<string>		m_strVecNtscThroughQuality;

	// PAL
	//
	vector<string>		m_strVecPalRes;

	vector<string>		m_strVecPalResSub;

	vector<string>		m_strVecPalFrameRate;

	vector<string>		m_strVecPalRecordMode;

	vector<string>		m_strVecPalBitrate;

	vector<string>		m_strVecPalQuality;

	vector<string>		m_strVecPalQpstep;

	vector<string>		m_strVecPalPeakBitrate;

	vector<string>		m_strVecPalThroughQuality;

	vector<string>		m_strVecBFrame;

public:

	BOOL InitResource();

	BOOL UnInitResource();

	CString GetWorkingPath( CString strWorkFile );

	CStringVector SplitString(const CString& strSource, const CString& delim, bool bRemoveNone);

	BOOL IsFileExists( const TCHAR * pFile );

	BOOL IsDirectoryExist(LPCTSTR szPath);

	BOOL CheckSchedule();

	VOID StartRecordimg( UINT nID, BOOL bSchedule );

	VOID StopRecordimg( UINT nID );
};
